package topdown.term;

import java.util.Map;

public class Variable implements Term {
    /* name of the variable */
    final String var;
    
    public Variable(String var) {
        this.var = var;
    }
    
    @Override
    public String toString() {
        return var;
    }
    
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Variable) {
            return var.equals(((Variable) obj).var);
        }
        return false;
    }
    
    @Override
    public int hashCode() {
        return (var + "var").hashCode();
    }
    
    @Override
    public Term substitute(Map<Variable, Term> substitution) {
        Term t = substitution.get(this);
        if (t != null) {
            return t.copy();
        }
        return this.copy();
    }
    
    @Override
    public Term copy() {
        return new Variable(var);
    }

}
